 	function	k = h_2_LATTICE_FIR(h)

	% 	Determines the coefficients of a nonrecursive lattice filter
	% 	from the impulse response of an FIR filter.
	
	% 	Example: h = [1 13/24 5/8 1/3] which yields
	% 	k = [1/3 0.5 0.25 1]
	
	% 	Toolbox for DIGITAL FILTERS USING MATLAB 
	
	% 	Author: 		Lars Wanhammar 2001-02-11
	% 	Modified by: 	 
	% 	Copyright:		by authors - not released for commercial use
	% 	Version:		1
	% 	Known bugs:		 
	% 	Report bugs to:	Wanhammar@gmail.com
		
	Nh = length(h);
	k = zeros(1, Nh);
	if h(1) == 0
		disp('h(1) must be  0')
	end
	k(1) = h(1);
	A = h/h(1);
	for n = Nh:-1:2
		k(n) = A(n);
		B = fliplr(A);
		A = (A - k(n)*B)/(1 - k(n)^2);
		A = A(1:Nh-1);
	end
